/*
 *  This file is part of MagiCapture.
 *  Copyright (C) 1999 Arthur Jerijian
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

/*
 * help.c: Online help routines
 */

#if HAVE_UNISTD_H
#include <unistd.h>
#endif /* HAVE_UNISTD_H */

#include <stdio.h>
#include <magick/api.h>
#include <magick/xwindows.h>
#include <glib.h>
#include <gdk/gdk.h>
#include <gtk/gtk.h>
#include <gdk_magick.h>

#include "common.h"
#include "widget.h"
#include "util.h"
#include "stringtable.h"
#include "version.h"
#include "help.h"

/*********************************************************************
 *
 * help_about: Display a dialog box with the program version and
 * copyright.
 *
 * Parameters:
 *   None.
 *
 * Return value:
 *   None.
 */

void help_about ()
{
    GtkWidget *window;

    /* Create the dialog box. */
    
    window = gtk_dialog_new ();
    gtk_window_set_modal (GTK_WINDOW (window), TRUE);
    
    gtk_window_set_title (GTK_WINDOW (window), TITLE_ABOUT);
    gtk_container_set_border_width (GTK_CONTAINER (window), 5);

    /* Add an OK button to the dialog box. */

    add_button
    (
        GTK_DIALOG (window) -> action_area,
        GTK_OBJECT (window),
        GTK_SIGNAL_FUNC (gtk_widget_destroy),
        LABEL_OK
    );

    /* Output the software version and copyright to the dialog box. */

    add_label
    (
        GTK_DIALOG (window) -> vbox,
        VERSION_TEXT
    );

    /* Display the dialog box. */
    
    gtk_widget_show (window);
}
